//120415 Driver for LTC2348 family of 8ch SAR ADCs
// Rev B fixes issue that prevented all channels from clocking out
//GMH
`timescale 1ps / 1ps
module RevA
(
	CSB_33,
	CLK,
	CNVCLK,
	SDO0,
	SDO1,
	SDO2,
	SDO3,
	SDO4,
	SDO5,
	SDO6,
	SDO7,
	SCK_33,
	BUSY_33,
	DB2,
	DB3,
	DB4,
	DB5,
	DB6,
	DB7,
	DB8,
	DB9,
	DB10,
	DB14,
	DB15,
	DB16,
	DB17,
	DB0,
	DB1,
	DB11,
	DB12,
	DB13,
	WRIN,
	WRIN2,
	B16_18L,
	SCK_IN,
	SCK_OUT,
	SDI_33,
	SDIIN,
	SCKIN,
	CNVIN,
	ID,
	IDOUT,
	A2,
	A1,
	A0,
	SS2,
	SS1,
	SS0,
	LVDS_CMOS_IN,
	LVDS_CMOS_IN_JP3,
	LVDS_CMOS_OUTPUT,
	AUX0,
	AUX1,
	d_latch_out,
	master_clk_out,
	master_clkd_out,
	data_latch_start,
	sdo_count,
	data_latch_out
);
output 			d_latch_out;								//pin7
output			data_latch_out;							//pin74
output			data_latch_start;							//pin72
output [3:0]	sdo_count;									//pins64-67
output			master_clk_out;							//pin10
output			master_clkd_out;							//pin11
output			IDOUT;										//pin114 not used
output			A2;											//
output			A1;											// A2-A0 give PScope address info on last ADC conversion
output			A0;											//
output			SS2;											//
output			SS1;											// SS2-SS0 give PScope SoftSpan Range info on last ADC conversion
output			SS0;											//
output			CSB_33;										// pin77 CSB_33 is unsynchronized CONV signal.  
input				ID;											// not used
input          WRIN;											//if WRIN=1 CPLD controls ADC
input				WRIN2;										//if WRIN2=0 sneakerport controls ADC
input				SDIIN;										// \
input				SCKIN;										//  |  use these to generate config word from DC890 virtual SPI
input				CNVIN;										// /
input				LVDS_CMOS_IN;								//from virtual SPI
input				LVDS_CMOS_IN_JP3;							//from JP3
input				AUX0;											//not used
input				AUX1;											//not used
output			LVDS_CMOS_OUTPUT;							//to ADC
input				CLK;											//Clock from DC2094 Clock is divided by 100 to set conv rate
output			CNVCLK;										//CNVCLK to PScope at conv rate 8 pulses per CONV
input				SDO0;											//SDO0-SDO7 from LTC2348
input				SDO1;
input				SDO2;
input				SDO3;
input				SDO4;
input				SDO5;
input				SDO6;
input				SDO7;
inout				SCK_33;										//SCK to LTC2348
inout       	SDI_33;										//SDI to LTC2348
input       	SCK_IN;										//Not used
input      		SCK_OUT;										//SCK_OUT from LTC2348 both edges used to clk data
input				BUSY_33;										//BUSY from LTC2348 not used
output			DB2;											//
output			DB3;											//
output			DB4;											//
output			DB5;											//
output			DB6;											//
output			DB7;											//
output			DB8;											//
output			DB9;											//
output			DB10;											//DB0-DB17 parallel data from LTC2348
output			DB14;											//
output			DB15;											//
output			DB16;											//
output			DB17;											//
output			DB0;											//
output			DB1;											//
output			DB11;											//
output			DB12;											//
output			DB13;											//
input				B16_18L;										//16bit/18bit detect 1=16 0=18
parameter 		CLR = 1'b0,
					SET = 1'b1,
					op = 1'b1,
					ip = 1'b0;	
reg [3:0] sdo_count;											//4/21/14 was wire
wire data_latch_start;
wire master_clk;												//same as CLK
reg [23:0] dout;
wire [23:0] mosi_par;										//added 2/7/14
wire SDIIN;														//added 2/7/14
wire SCKIN;														//added 2/7/14
wire CNVIN;														//added 2/7/14
wire WRIN;														//added 2/7/14
wire WRIN2;														//added 2/7/14
wire LVDS_CMOS_IN;											//added 2/7/14				
wire LVDS_CMOS_IN_JP3;										//added 2/7/14
wire LVDS_CMOS_OUTPUT;										//added 2/7/14

assign LVDS_CMOS_OUTPUT = 1'b0;			// modified 04/06/15 forces LVDS/CMOS pin on ADC to CMOS position


wire SDO0;							//added 4/21/14
wire SDO1;
wire SDO2;
wire SDO3;
wire SDO4;
wire SDO5;
wire SDO6;
wire SDO7;

reg [11:0]sdoO0;
reg [11:0]sdoO1;
reg [11:0]sdoO2;
reg [11:0]sdoO3;
reg [11:0]sdoO4;
reg [11:0]sdoO5;
reg [11:0]sdoO6;
reg [11:0]sdoO7;
reg [11:0]sdoE0;
reg [11:0]sdoE1;
reg [11:0]sdoE2;
reg [11:0]sdoE3;
reg [11:0]sdoE4;
reg [11:0]sdoE5;
reg [11:0]sdoE6;
reg [11:0]sdoE7;

wire [23:0]sdo0;
wire [23:0]sdo1;
wire [23:0]sdo2;
wire [23:0]sdo3;
wire [23:0]sdo4;
wire [23:0]sdo5;
wire [23:0]sdo6;
wire [23:0]sdo7;

reg [2:0] i;


									//added 4/21/14

wire mosi;
wire aux0;
wire conv;
wire sck;
wire B34;
wire B30;
reg data_latch;				//4/21/14 was wire
//wire data_latchl /* synthesis keep */;											
//wire data_latcha /* synthesis keep */;											
wire master_clk_0 /* synthesis keep */;				
wire master_clk_1 /* synthesis keep */;
wire master_clk_2 /* synthesis keep */;
wire master_clk_3 /* synthesis keep */;
wire master_clk_4 /* synthesis keep */;
wire master_clk_5 /* synthesis keep */;
wire master_clk_6 /* synthesis keep */;
wire master_clk_7 /* synthesis keep */;
wire master_clk_8 /* synthesis keep */;
wire master_clk_9 /* synthesis keep */;
reg master_out_0; //preserve
reg master_out_1; //preserve
reg master_out_2; //preserve
reg master_out_3; //preserve
reg master_out_4; //preserve
reg master_out_5; //preserve
reg master_out_6; //preserve
reg master_out_7; //preserve
reg master_out_8; //preserve
reg master_out_9; //preserve
wire master_clk_10 /* synthesis keep */;										
wire master_clk_11 /* synthesis keep */;
wire master_clk_12 /* synthesis keep */;
wire master_clk_13 /* synthesis keep */;
wire master_clk_14 /* synthesis keep */;
wire master_clk_15 /* synthesis keep */;
wire master_clk_16 /* synthesis keep */;
wire master_clk_17 /* synthesis keep */;
wire master_clk_18 /* synthesis keep */;
wire master_clk_19 /* synthesis keep */;
reg master_out_10; //preserve
reg master_out_11; //preserve
reg master_out_12; //preserve
reg master_out_13; //preserve
reg master_out_14; //preserve
reg master_out_15; //preserve
reg master_out_16; //preserve
reg master_out_17; //preserve
reg master_out_18; //preserve
reg master_out_19; //preserve
wire miso0;
wire miso1;
wire miso2;
wire miso3;
wire miso4;
wire miso5;
wire miso6;
wire miso7;
reg DB0;
reg DB1;
reg DB2;
reg DB3;
reg DB4;
reg DB5;														
reg DB6;
reg DB7;
reg DB8;
reg DB9;
reg DB10;
reg DB11;
reg DB12;
reg DB13;
reg DB14;
reg DB15;
reg DB16;
reg DB17;

reg A2;
reg A1;
reg A0;
reg SS2;
reg SS1;
reg SS0;

wire [7:0]a2;
wire [7:0]a1;
wire [7:0]a0;
wire [7:0]ss2;
wire [7:0]ss1;
wire [7:0]ss0;
wire [7:0]sdob0;
wire [7:0]sdob1;
wire [7:0]sdob2;
wire [7:0]sdob3;
wire [7:0]sdob4;
wire [7:0]sdob5;
wire [7:0]sdob6;
wire [7:0]sdob7;
wire [7:0]sdob8;
wire [7:0]sdob9;
wire [7:0]sdob10;
wire [7:0]sdob11;
wire [7:0]sdob12;
wire [7:0]sdob13;
wire [7:0]sdob14;
wire [7:0]sdob15;
wire [7:0]sdob16;
wire [7:0]sdob17;
													
wire BUSY_33;
wire CNVCLK;
reg clkdiv2;
wire clkout_latch;																	
wire d_latch;
wire B16_18L;
wire ID;
reg IDOUT;																			
wire SCK_IN;
wire SCK_OUT;
wire numbits;
/*
assign numbits = 1'b0;									//04/07/15 was B16_18L use to set data direction and pin assignments 1=16bits 0=18bits
//assign SCK_OUT = SCK_IN | SCKIN | SDIIN | CNVIN;
//assign IDOUT = ID;
    always @(posedge d_latch )begin//	 				//	changed 11/21/13 was negedge d_latch					      					    														
				if (numbits==1) begin////
					DB15 <= dout[21];
					DB14 <= dout[20];
					DB13 <= dout[19];
					DB12 <= dout[18];
					DB11 <= dout[17];
					DB10 <= dout[16];
					DB9 <= dout[15];
					DB8 <= dout[14];
					DB7 <= dout[13];
					DB6 <= dout[12];
					DB5 <= dout[11];
					DB4 <= dout[10];
					DB3 <= dout[9];
					DB2 <= dout[8];
					DB1 <= dout[7];
					DB0 <= dout[6];
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					IDOUT <= sdo_count[3];
					SS2 <= sdo_count[2];
					SS1 <= sdo_count[1];
					SS0 <= sdo_count[0];
					
					DB17 <= 0;
					DB16 <= 0;									// 16bit
				end////	    
				else begin////
					DB17 <= dout[23];
					DB16 <= dout[22];
					DB15 <= dout[21];
					DB14 <= dout[20];
					DB13 <= dout[19];
					DB12 <= dout[18];
					DB11 <= dout[17];
					DB10 <= dout[16];
					DB9 <= dout[15];
					DB8 <= dout[14];
					DB7 <= dout[13];
					DB6 <= dout[12];
					DB5 <= dout[11];
					DB4 <= dout[10];
					DB3 <= dout[9];
					DB2 <= dout[8];
					DB1 <= dout[7];
					DB0 <= dout[6];							// 18bit
					A2 <= dout[5];
					A1 <= dout[4];
					A0 <= dout[3];
					IDOUT <= sdo_count[3];
					SS2 <= sdo_count[2];
					SS1 <= sdo_count[1];
					SS0 <= sdo_count[0];
					
				end////
    end//

   */
assign master_clk = CLK & WRIN;						  			//CLK active when WRIN is high.
assign master_clk_0 = ~master_clk;
assign master_clk_1 = ~master_clk_0;
assign master_clk_2 = ~master_clk_1;
assign master_clk_3 = ~master_clk_2;
assign master_clk_4 = ~master_clk_3;
assign master_clk_5 = ~master_clk_4;
assign master_clk_6 = ~master_clk_5;
assign master_clk_7 = ~master_clk_6;
assign master_clk_8 = ~master_clk_7;
assign master_clk_9 = ~master_clk_8;

assign master_clk_10 = ~master_clk_9;
assign master_clk_11 = ~master_clk_10;
assign master_clk_12 = ~master_clk_11;
assign master_clk_13 = ~master_clk_12;
assign master_clk_14 = ~master_clk_13;
assign master_clk_15 = ~master_clk_14;
assign master_clk_16 = ~master_clk_15;
assign master_clk_17 = ~master_clk_16;
assign master_clk_18 = ~master_clk_17;
assign master_clk_19 = ~master_clk_18;

/*assign miso0 = SDO0;
assign miso1 = SDO1;
assign miso2 = SDO2;
assign miso3 = SDO3;
assign miso4 = SDO4;
assign miso5 = SDO5;
assign miso6 = SDO6;
assign miso7 = SDO7;
*/

assign ss0= {sdoE7[0],sdoE6[0],sdoE5[0],sdoE4[0],sdoE3[0],sdoE2[0],sdoE1[0],sdoE0[0]};
assign ss1=	{sdoO7[0],sdoO6[0],sdoO5[0],sdoO4[0],sdoO3[0],sdoO2[0],sdoO1[0],sdoO0[0]};															
assign ss2=	{sdoE7[1],sdoE6[1],sdoE5[1],sdoE4[1],sdoE3[1],sdoE2[1],sdoE1[1],sdoE0[1]};															
assign a0=	{sdoO7[1],sdoO6[1],sdoO5[1],sdoO4[1],sdoO3[1],sdoO2[1],sdoO1[1],sdoO0[1]};															
assign a1=	{sdoE7[2],sdoE6[2],sdoE5[2],sdoE4[2],sdoE3[2],sdoE2[2],sdoE1[2],sdoE0[2]};															
assign a2=	{sdoO7[2],sdoO6[2],sdoO5[2],sdoO4[2],sdoO3[2],sdoO2[2],sdoO1[2],sdoO0[2]};															
assign sdob0 = {sdoE7[3],sdoE6[3],sdoE5[3],sdoE4[3],sdoE3[3],sdoE2[3],sdoE1[3],sdoE0[3]};																
assign sdob1 = {sdoO7[3],sdoO6[3],sdoO5[3],sdoO4[3],sdoO3[3],sdoO2[3],sdoO1[3],sdoO0[3]};
assign sdob2 = {sdoE7[4],sdoE6[4],sdoE5[4],sdoE4[4],sdoE3[4],sdoE2[4],sdoE1[4],sdoE0[4]};
assign sdob3 = {sdoO7[4],sdoO6[4],sdoO5[4],sdoO4[4],sdoO3[4],sdoO2[4],sdoO1[4],sdoO0[4]};
assign sdob4 = {sdoE7[5],sdoE6[5],sdoE5[5],sdoE4[5],sdoE3[5],sdoE2[5],sdoE1[5],sdoE0[5]};																	
assign sdob5 = {sdoO7[5],sdoO6[5],sdoO5[5],sdoO4[5],sdoO3[5],sdoO2[5],sdoO1[5],sdoO0[5]};																	
assign sdob6 = {sdoE7[6],sdoE6[6],sdoE5[6],sdoE4[6],sdoE3[6],sdoE2[6],sdoE1[6],sdoE0[6]};																	
assign sdob7 = {sdoO7[6],sdoO6[6],sdoO5[6],sdoO4[6],sdoO3[6],sdoO2[6],sdoO1[6],sdoO0[6]};																	
assign sdob8 = {sdoE7[7],sdoE6[7],sdoE5[7],sdoE4[7],sdoE3[7],sdoE2[7],sdoE1[7],sdoE0[7]};																	
assign sdob9 = {sdoO7[7],sdoO6[7],sdoO5[7],sdoO4[7],sdoO3[7],sdoO2[7],sdoO1[7],sdoO0[7]};																	
assign sdob10 = {sdoE7[8],sdoE6[8],sdoE5[8],sdoE4[8],sdoE3[8],sdoE2[8],sdoE1[8],sdoE0[8]};																	
assign sdob11 = {sdoO7[8],sdoO6[8],sdoO5[8],sdoO4[8],sdoO3[8],sdoO2[8],sdoO1[8],sdoO0[8]};																	
assign sdob12 = {sdoE7[9],sdoE6[9],sdoE5[9],sdoE4[9],sdoE3[9],sdoE2[9],sdoE1[9],sdoE0[9]};																	
assign sdob13 = {sdoO7[9],sdoO6[9],sdoO5[9],sdoO4[9],sdoO3[9],sdoO2[9],sdoO1[9],sdoO0[9]};																	
assign sdob14 = {sdoE7[10],sdoE6[10],sdoE5[10],sdoE4[10],sdoE3[10],sdoE2[10],sdoE1[10],sdoE0[10]};																	
assign sdob15 = {sdoO7[10],sdoO6[10],sdoO5[10],sdoO4[10],sdoO3[10],sdoO2[10],sdoO1[10],sdoO0[10]};																	
assign sdob16 = {sdoE7[11],sdoE6[11],sdoE5[11],sdoE4[11],sdoE3[11],sdoE2[11],sdoE1[11],sdoE0[11]};																	
assign sdob17 = {sdoO7[11],sdoO6[11],sdoO5[11],sdoO4[11],sdoO3[11],sdoO2[11],sdoO1[11],sdoO0[11]};


assign sdo0 = {sdoO0[11],sdoE0[11],sdoO0[10],sdoE0[10],sdoO0[9],sdoE0[9],sdoO0[8],sdoE0[8],sdoO0[7],sdoE0[7],sdoO0[6],sdoE0[6],sdoO0[5],sdoE0[5],sdoO0[4],sdoE0[4],sdoO0[3],sdoE0[3],sdoO0[2],sdoE0[2],sdoO0[1],sdoE0[1],sdoO0[0],sdoE0[0]};
assign sdo1 = {sdoO1[11],sdoE1[11],sdoO1[10],sdoE1[10],sdoO1[9],sdoE1[9],sdoO1[8],sdoE1[8],sdoO1[7],sdoE1[7],sdoO1[6],sdoE1[6],sdoO1[5],sdoE1[5],sdoO1[4],sdoE1[4],sdoO1[3],sdoE1[3],sdoO1[2],sdoE1[2],sdoO1[1],sdoE1[1],sdoO1[0],sdoE1[0]};
assign sdo2 = {sdoO2[11],sdoE2[11],sdoO2[10],sdoE2[10],sdoO2[9],sdoE2[9],sdoO2[8],sdoE2[8],sdoO2[7],sdoE2[7],sdoO2[6],sdoE2[6],sdoO2[5],sdoE2[5],sdoO2[4],sdoE2[4],sdoO2[3],sdoE2[3],sdoO2[2],sdoE2[2],sdoO2[1],sdoE2[1],sdoO2[0],sdoE2[0]};
assign sdo3 = {sdoO3[11],sdoE3[11],sdoO3[10],sdoE3[10],sdoO3[9],sdoE3[9],sdoO3[8],sdoE3[8],sdoO3[7],sdoE3[7],sdoO3[6],sdoE3[6],sdoO3[5],sdoE3[5],sdoO3[4],sdoE3[4],sdoO3[3],sdoE3[3],sdoO3[2],sdoE3[2],sdoO3[1],sdoE3[1],sdoO3[0],sdoE3[0]};
assign sdo4 = {sdoO4[11],sdoE4[11],sdoO4[10],sdoE4[10],sdoO4[9],sdoE4[9],sdoO4[8],sdoE4[8],sdoO4[7],sdoE4[7],sdoO4[6],sdoE4[6],sdoO4[5],sdoE4[5],sdoO4[4],sdoE4[4],sdoO4[3],sdoE4[3],sdoO4[2],sdoE4[2],sdoO4[1],sdoE4[1],sdoO4[0],sdoE4[0]};
assign sdo5 = {sdoO5[11],sdoE5[11],sdoO5[10],sdoE5[10],sdoO5[9],sdoE5[9],sdoO5[8],sdoE5[8],sdoO5[7],sdoE5[7],sdoO5[6],sdoE5[6],sdoO5[5],sdoE5[5],sdoO5[4],sdoE5[4],sdoO5[3],sdoE5[3],sdoO5[2],sdoE5[2],sdoO5[1],sdoE5[1],sdoO5[0],sdoE5[0]};
assign sdo6 = {sdoO6[11],sdoE6[11],sdoO6[10],sdoE6[10],sdoO6[9],sdoE6[9],sdoO6[8],sdoE6[8],sdoO6[7],sdoE6[7],sdoO6[6],sdoE6[6],sdoO6[5],sdoE6[5],sdoO6[4],sdoE6[4],sdoO6[3],sdoE6[3],sdoO6[2],sdoE6[2],sdoO6[1],sdoE6[1],sdoO6[0],sdoE6[0]};
assign sdo7 = {sdoO7[11],sdoE7[11],sdoO7[10],sdoE7[10],sdoO7[9],sdoE7[9],sdoO7[8],sdoE7[8],sdoO7[7],sdoE7[7],sdoO7[6],sdoE7[6],sdoO7[5],sdoE7[5],sdoO7[4],sdoE7[4],sdoO7[3],sdoE7[3],sdoO7[2],sdoE7[2],sdoO7[1],sdoE7[1],sdoO7[0],sdoE7[0]};
always @(posedge SCK_OUT) begin 								// SCK_OUT 1/2 master clk frequency
	sdoO0 <= {sdoO0[10:0],SDO0};								// latch data bit, place in proper location of dout
	sdoO1 <= {sdoO1[10:0],SDO1};
	sdoO2 <= {sdoO2[10:0],SDO2};
	sdoO3 <= {sdoO3[10:0],SDO3};
	sdoO4 <= {sdoO4[10:0],SDO4};
	sdoO5 <= {sdoO5[10:0],SDO5};
	sdoO6 <= {sdoO6[10:0],SDO6};
	sdoO7 <= {sdoO7[10:0],SDO7};
end 

always @(negedge SCK_OUT) begin 					// SCK_OUT 1/2 master clk frequency
	sdoE0 <= {sdoE0[10:0],SDO0};								// latch data bit, place in proper location of dout
	sdoE1 <= {sdoE1[10:0],SDO1};
	sdoE2 <= {sdoE2[10:0],SDO2};
	sdoE3 <= {sdoE3[10:0],SDO3};
	sdoE4 <= {sdoE4[10:0],SDO4};
	sdoE5 <= {sdoE5[10:0],SDO5};
	sdoE6 <= {sdoE6[10:0],SDO6};
	sdoE7 <= {sdoE7[10:0],SDO7};
end 

always @ ( posedge d_latch ) begin//

/*if (WRIN==0) begin///		
i <= 3'b000;
end///
*/
/*if (d_latch==1) begin/// */

					DB17 <= sdob17[i];					//new data latch method combined with lines 403-426
					DB16 <= sdob16[i];
					DB15 <= sdob15[i];
					DB14 <= sdob14[i];
					DB13 <= sdob13[i];
					DB12 <= sdob12[i];
					DB11 <= sdob11[i];
					DB10 <= sdob10[i];
					DB9 <= sdob9[i];
					DB8 <= sdob8[i];
					DB7 <= sdob7[i];
					DB6 <= sdob6[i];
					DB5 <= sdob5[i];
					DB4 <= sdob4[i];
					DB3 <= sdob3[i];
					DB2 <= sdob2[i];
					DB1 <= sdob1[i];
					DB0 <= sdob0[i];							// 16bit and 18bit use same data output
																	// DB0 and DB1 are 0s for 16-bit part
					A2 <= a2[i];
					A1 <= a1[i];
					A0 <= a0[i];

					IDOUT <= d_latch;							//for diagnostic only
					SS2 <= ss2[i];
					SS1 <= ss1[i];
					SS0 <= ss0[i];
					
end///

always @ (negedge d_latch) begin///

i<=i+1;

end///
//end//


/*always @( posedge data_latch_start or negedge WRIN) begin//		//modified 11/21/13 was posedge data_latch (switch data from sdo0-7 to dout with 8 clocks)

														                     //need 10 data_latch_start pulses and 8 data_latch pulses to properly load all 8 sdo words.
if (WRIN==0) begin//		
sdo_count <= 4'b0000;
end//
else begin//
	case (sdo_count)
4'b0000 : begin
		dout <= sdo0;
		data_latch<= 1'b1;									//5/7/14 was 1'b1
		sdo_count <= sdo_count + 4'b0001;
		end
4'b0001 : begin
		dout <= sdo1;
		data_latch <= 1'b1;
		sdo_count <= sdo_count + 4'b0001;
		end
4'b0010 : begin
		dout <= sdo2;
		data_latch <= 1'b1;
		sdo_count <=sdo_count + 4'b0001;
		end
4'b0011 : begin
		dout <= sdo3;
		data_latch <= 1'b1;
		sdo_count <=sdo_count + 4'b0001;
		end
4'b0100 : begin
		dout <= sdo4;
		data_latch <= 1'b1;
		sdo_count <= sdo_count + 4'b0001;					// old data latch method
		end
4'b0101 : begin
		dout <= sdo5;
		data_latch <= 1'b1;
		sdo_count <=sdo_count + 4'b0001;
		end
4'b0110 : begin
		dout <= sdo6;
		data_latch <= 1'b1;
		sdo_count <= sdo_count + 4'b0001;
		end
4'b0111 : begin
		dout <= sdo7;
		data_latch <= 1'b1;
		sdo_count <= sdo_count + 4'b0001;
		end
4'b1000 : begin
		//dout <=sdo7;
		data_latch <= 1'b0;								//5/7/14 was 1'b0
		sdo_count <=  4'b0000;			//5/9/14 was 4'b0000
		end
4'b1001 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
4'b1010 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end		
4'b1011 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
4'b1100 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
4'b1101 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
4'b1110 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
4'b1111 : begin
		data_latch <= 1'b0;
		sdo_count <= 4'b0000;
		end
		
default : sdo_count <= 4'b0000;			//changed 11/21/13 was <= sdo_count + 4'b0001
endcase
end



end

*/
													//added 4/21/14





assign CSB_33 = ~conv ;		

assign data_latch_out = data_latch_start;			
assign d_latch = data_latch_start & master_clk_1 ;	//5/12/14 was master_clk ,    on posedge DB0-DB17,A0-A2 and SS0-SS2 are updated. delayed version of data_latch_start 
assign d_latch_out = d_latch;					   //d_latch to outside world
assign master_clk_out = master_clk;	
assign master_clkd_out = master_clk_15;							
assign CNVCLK =  data_latch_start & master_clk_5;		//5/12/14 was master_clk_13 8 pulses to tell DC890 when to grab data. grab on neg edge.		delayed version of d_latch							

dff dff1(.d(0), .clk(CLK), .clrn(1), .prn(~data_latch), .q(clkout_latch));
dff dffmc0(.d(0), .clk(master_clk_0), .clrn(1), .prn(1), .q(master_out_0));
dff dffmc1(.d(0), .clk(master_clk_1), .clrn(1), .prn(1), .q(master_out_1));
dff dffmc2(.d(0), .clk(master_clk_2), .clrn(1), .prn(1), .q(master_out_2));
dff dffmc3(.d(0), .clk(master_clk_3), .clrn(1), .prn(1), .q(master_out_3));
dff dffmc4(.d(0), .clk(master_clk_4), .clrn(1), .prn(1), .q(master_out_4));
dff dffmc5(.d(0), .clk(master_clk_5), .clrn(1), .prn(1), .q(master_out_5));
dff dffmc6(.d(0), .clk(master_clk_6), .clrn(1), .prn(1), .q(master_out_6));
dff dffmc7(.d(0), .clk(master_clk_7), .clrn(1), .prn(1), .q(master_out_7));
dff dffmc8(.d(0), .clk(master_clk_8), .clrn(1), .prn(1), .q(master_out_8));
dff dffmc9(.d(0), .clk(master_clk_9), .clrn(1), .prn(1), .q(master_out_9));

dff dffmc10(.d(0), .clk(master_clk_10), .clrn(1), .prn(1), .q(master_out_10));
dff dffmc11(.d(0), .clk(master_clk_11), .clrn(1), .prn(1), .q(master_out_11));
dff dffmc12(.d(0), .clk(master_clk_12), .clrn(1), .prn(1), .q(master_out_12));
dff dffmc13(.d(0), .clk(master_clk_13), .clrn(1), .prn(1), .q(master_out_13));
dff dffmc14(.d(0), .clk(master_clk_14), .clrn(1), .prn(1), .q(master_out_14));
dff dffmc15(.d(0), .clk(master_clk_15), .clrn(1), .prn(1), .q(master_out_15));
dff dffmc16(.d(0), .clk(master_clk_16), .clrn(1), .prn(1), .q(master_out_16));
dff dffmc17(.d(0), .clk(master_clk_17), .clrn(1), .prn(1), .q(master_out_17));
dff dffmc18(.d(0), .clk(master_clk_18), .clrn(1), .prn(1), .q(master_out_18));
dff dffmc19(.d(0), .clk(master_clk_19), .clrn(1), .prn(1), .q(master_out_19));
									
serial_io io_2(.master_clk		(master_clk),	   		//clk in from DC2094
					.mosi	 	   	(mosi), 	   	   		//sdi to 2348
					.sck		 		(sck),		   			//sck to 2348 
					.conv	 	   	(conv),		   			//conv or conv_gate to 2348
					.aux0	 	   	(aux0), 		   			//aux signal not used for all parts
					.mcd				(master_clk_1),			//delayed version of master_clk //5/9/14 was master_clk_3
					.B16_18L			(1'b0),						//04/07/15 was B16_18L 16-bit/18-bit select
					.WRIN				(WRIN),						//if WRIN=1 CPLD controls ADC, if WRIN=0 sneakerport controls ADC
					.mosi_par      (mosi_par),					//added 2/7/14 config word from DC890
					.d_latch			(data_latch_start)		//10 data_latch pulses was data_latch_start
			);
	wire LVDS_CMOS_OUT;											//added 10/16/14
VSPI VSPI_1		(.WRIN  			(WRIN),						//control line for CNV 0=program 1=run
					.WRIN2 			(WRIN2),						//control line for SPI 0=program 1=run
					.SDIIN 			(SDIIN),						//virtual SDI from DC890
					.SCKIN 			(SCKIN),						//virtual SCK from DC890
					.CNVIN 			(CNVIN),						//virtual CNV from DC890
					.LVDS_CMOS_IN 	(LVDS_CMOS_IN),			//1=LVDS 0=CMOS
					.AUX0 			(AUX0),						//future use
					.AUX1 			(AUX1),						//future use
					.MOSI_OUT 		(mosi_par),					//MOSI word for serial_io module
					.LVDS_CMOS_OUT	(LVDS_CMOS_OUT)		   //1=LVDS 0=CMOS 10/16/14 was LVDS_CMOS_OUTPUT
				);

 alt_iobuf															//primitive for CycloneIII IO pin
 d_bit_34		(.i  				(sck),						//serial_clk_out to ADC
					.oe  				(WRIN),						//WRIN=1 SCK_33=sck, WRIN=0 SCK_33=HiZ
					.o 				(B34),						//
					.io  				(SCK_33));					//IO pin
// defparam d_bit_34.operation_mode = "bidir";
 
 alt_iobuf															//primitive for CycloneIII IO pin
 d_bit_30		(.i  				(CLR),						//master_out_slave_in (to ADC SDI pin)
					.oe  				(WRIN),						//WRIN=1 SDI_33=sdi, WRIN=0 SDI_33=HiZ
					.o 				(B30),						//
					.io  				(SDI_33));					//IO pin
// defparam d_bit_30.operation_mode = "bidir";
 

endmodule

